<?php
require "config.php";
global $SITE_NAME,$LOGO_PATH,$FAVICON_PATH;

session_start();
$pdo = db();

function is_admin(): bool { return !empty($_SESSION['admin']); }

function menu_item(string $label, string $href): void {
  echo '<a href="'.htmlspecialchars($href, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($label, ENT_QUOTES, 'UTF-8').'</a>';
}

$brandText = strtoupper($SITE_NAME ?: "MY SHORTENER");

/* ---------- LOGOUT ---------- */
if (isset($_GET['logout'])) {
  $_SESSION = [];
  session_destroy();
  header("Location: /admin.php");
  exit;
}

/* ---------- LOGIN ---------- */
$loginErr = "";
if (!is_admin() && $_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['do_login'])) {
  global $ADMIN_USER,$ADMIN_PASS;
  $u = trim($_POST['username'] ?? "");
  $p = trim($_POST['password'] ?? "");
  if ($u === $ADMIN_USER && $p === $ADMIN_PASS) {
    $_SESSION['admin'] = 1;
    header("Location: /admin.php");
    exit;
  } else {
    $loginErr = "Wrong username or password.";
  }
}

/* ---------- LOGIN PAGE ---------- */
if (!is_admin()):
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login - <?= e($SITE_NAME ?: "URL Shortener") ?></title>
  <link rel="icon" href="<?= e($FAVICON_PATH) ?>">
  <link rel="stylesheet" href="/assets/style.css">
  <style>
    /* Admin Login – fully responsive */
    .loginWrap{
      min-height: calc(100vh - 170px);
      display:flex; align-items:center; justify-content:center;
      padding: 24px 0;
    }
    .loginCard{
      width:100%; max-width:460px;
      padding:26px 22px;
      border-radius:22px;
      border:1px solid rgba(255,255,255,.12);
      background: linear-gradient(180deg, rgba(255,255,255,.08), rgba(255,255,255,.04));
      box-shadow: 0 30px 80px rgba(0,0,0,.55);
    }
    .loginTitle{font-size:28px;font-weight:900;margin:0 0 8px}
    .loginSub{margin:0 0 16px;color:rgba(238,242,255,.68);line-height:1.7}
    .adminForm label{display:block;margin-top:10px;color:rgba(238,242,255,.70);font-size:13px}
    .adminForm input{
      width:100%; padding:14px 14px; border-radius:16px;
      border:1px solid rgba(255,255,255,.14);
      background: rgba(255,255,255,.05);
      color: rgba(238,242,255,1);
      outline:none;
    }
    .adminForm input:focus{border-color: rgba(72,193,154,.55)}
    .loginBtn{
      width:100%; margin-top:14px;
      padding:14px 14px; border-radius:16px;
      border:1px solid rgba(255,255,255,.14);
      cursor:pointer; font-weight:900; font-size:18px;
      background: linear-gradient(135deg, rgba(110,168,255,.35), rgba(139,92,255,.28));
      color: rgba(238,242,255,1);
    }
    .loginBtn:hover{filter:brightness(1.06)}
    .hintBox{
      margin-top:14px; padding:12px 12px; border-radius:14px;
      border:1px solid rgba(255,255,255,.12);
      background: rgba(255,255,255,.04);
      color: rgba(238,242,255,.70);
      font-size:13px; line-height:1.6;
    }
  </style>
</head>
<body>

<header class="topbar">
  <div class="container topbarInner">
    <a class="brand" href="/">
      <img class="brandLogo" src="<?= e($LOGO_PATH) ?>" alt="Logo" onerror="this.style.display='none'">
      <div class="brandName"><?= e($brandText) ?></div>
    </a>

    <div class="menuWrap">
      <button class="hamburger" id="hamburgerBtn" type="button" aria-label="Menu">☰</button>
      <div class="dropdown" id="dropdown">
        <?php
          menu_item("Home", "/");
          menu_item("Privacy Policy", "/?page=privacy");
          menu_item("Terms & Conditions", "/?page=terms");
          menu_item("Disclaimer", "/?page=disclaimer");
          menu_item("Contact", "/?page=contact");
        ?>
      </div>
    </div>
  </div>
</header>

<main class="container">
  <div class="loginWrap">
    <div class="loginCard">
      <h1 class="loginTitle">Admin Login</h1>
      <p class="loginSub">Sign in to manage links: add, edit, delete and search.</p>

      <form class="adminForm" method="post">
        <input type="hidden" name="do_login" value="1">

        <label>Username</label>
        <input name="username" required placeholder="Enter username" value="admin">

        <label>Password</label>
        <input name="password" type="password" required placeholder="Enter password" value="123456">

        <button class="loginBtn" type="submit">Login</button>
      </form>

      <?php if ($loginErr): ?>
        <div class="result bad" style="margin-top:12px"><?= e($loginErr) ?></div>
      <?php endif; ?>

      <div class="hintBox">
        <b>Default:</b> admin / 123456<br>
        Security: পরে config.php এ password বদলান।
      </div>
    </div>
  </div>

  <footer class="footer">
    <div class="footerRow">
      <div>© <?= date('Y') ?> <?= e($SITE_NAME ?: "URL Shortener") ?></div>
      <div class="footerLinks">
        <a href="/?page=privacy">Privacy</a>
        <a href="/?page=terms">Terms</a>
        <a href="/?page=disclaimer">Disclaimer</a>
        <a href="/?page=contact">Contact</a>
      </div>
    </div>
  </footer>
</main>

<script>
(function(){
  const btn = document.getElementById('hamburgerBtn');
  const dd  = document.getElementById('dropdown');
  if(btn && dd){
    btn.addEventListener('click', (e)=>{ e.stopPropagation(); dd.classList.toggle('open'); });
    document.addEventListener('click', ()=> dd.classList.remove('open'));
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') dd.classList.remove('open'); });
  }
})();
</script>
</body>
</html>
<?php
exit;
endif;

/* ---------- ADMIN CRUD ---------- */
$notice = "";

/* ADD */
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_url'])) {
  $long = trim($_POST['long_url'] ?? "");
  $title = trim($_POST['title'] ?? "");
  $code  = trim($_POST['code'] ?? "");

  if (!$long || !is_valid_url($long)) $notice = "Please enter a valid URL (http/https).";
  else {
    if ($code) {
      if (!preg_match('/^[A-Za-z0-9]{3,20}$/', $code)) $notice = "Custom code must be 3-20 chars (A-Z a-z 0-9).";
      else {
        $st = $pdo->prepare("SELECT id FROM urls WHERE code=? LIMIT 1");
        $st->execute([$code]);
        if ($st->fetch()) $notice = "This code already exists.";
      }
    } else {
      do {
        $code = make_code(6);
        $st = $pdo->prepare("SELECT id FROM urls WHERE code=? LIMIT 1");
        $st->execute([$code]);
        $exists = $st->fetch();
      } while($exists);
    }

    if (!$notice) {
      $st = $pdo->prepare("INSERT INTO urls(code,long_url,title) VALUES(?,?,?)");
      $st->execute([$code, $long, $title ?: null]);
      $notice = "Added: " . base_url() . "/r/" . $code;
    }
  }
}

/* DELETE */
if (isset($_GET['delete'])) {
  $id = (int)$_GET['delete'];
  $pdo->prepare("DELETE FROM urls WHERE id=?")->execute([$id]);
  header("Location: /admin.php");
  exit;
}

/* EDIT LOAD */
$editRow = null;
if (isset($_GET['edit'])) {
  $id = (int)$_GET['edit'];
  $st = $pdo->prepare("SELECT * FROM urls WHERE id=? LIMIT 1");
  $st->execute([$id]);
  $editRow = $st->fetch();
  if (!$editRow) $notice = "Link not found.";
}

/* UPDATE */
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['update_url'])) {
  $id = (int)($_POST['id'] ?? 0);
  $long = trim($_POST['long_url'] ?? "");
  $title = trim($_POST['title'] ?? "");
  $code = trim($_POST['code'] ?? "");

  if (!$id) $notice = "Invalid ID.";
  else if (!$long || !is_valid_url($long)) $notice = "Please enter a valid URL.";
  else if (!$code || !preg_match('/^[A-Za-z0-9]{3,20}$/', $code)) $notice = "Code must be 3-20 chars (A-Z a-z 0-9).";
  else {
    $st = $pdo->prepare("SELECT id FROM urls WHERE code=? AND id<>? LIMIT 1");
    $st->execute([$code, $id]);
    if ($st->fetch()) $notice = "This code is used by another link.";
    else {
      $st = $pdo->prepare("UPDATE urls SET code=?, long_url=?, title=? WHERE id=?");
      $st->execute([$code, $long, $title ?: null, $id]);
      header("Location: /admin.php");
      exit;
    }
  }
}

/* SEARCH */
$q = trim($_GET['q'] ?? "");
$params = [];
$sql = "SELECT * FROM urls";
if ($q !== "") {
  $sql .= " WHERE code LIKE ? OR long_url LIKE ? OR title LIKE ?";
  $like = "%".$q."%";
  $params = [$like,$like,$like];
}
$sql .= " ORDER BY id DESC LIMIT 300";
$st = $pdo->prepare($sql);
$st->execute($params);
$rows = $st->fetchAll();

/* STATS */
$totalLinks = (int)($pdo->query("SELECT COUNT(*) c FROM urls")->fetch()['c'] ?? 0);
$totalClicks = (int)($pdo->query("SELECT IFNULL(SUM(clicks),0) s FROM urls")->fetch()['s'] ?? 0);
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin - <?= e($SITE_NAME ?: "URL Shortener") ?></title>
  <link rel="icon" href="<?= e($FAVICON_PATH) ?>">
  <link rel="stylesheet" href="/assets/style.css">

  <!-- Important: Admin responsive CSS is embedded so mobile looks perfect -->
  <style>
    /* Fix form layout regardless of main CSS */
    .adminForm label{display:block;margin-top:10px;color:rgba(238,242,255,.70);font-size:13px}
    .adminForm input{
      width:100%; padding:14px 14px; border-radius:16px;
      border:1px solid rgba(255,255,255,.14);
      background: rgba(255,255,255,.05);
      color: rgba(238,242,255,1);
      outline:none;
    }
    .adminForm input:focus{border-color: rgba(72,193,154,.55)}
    .adminBtns{display:flex;gap:10px;flex-wrap:wrap;margin-top:12px}

    .dashGrid{display:grid;grid-template-columns:1fr;gap:14px}
    .statsRow{display:grid;grid-template-columns:repeat(2,minmax(0,1fr));gap:10px;margin-top:14px}
    .statCard{
      padding:14px;border-radius:18px;
      border:1px solid rgba(255,255,255,.10);
      background: rgba(255,255,255,.04);
    }
    .statLbl{color: rgba(238,242,255,.65)}
    .statNum{font-size:28px;font-weight:900;margin-top:6px}

    .twoCol{display:grid;grid-template-columns:1fr 1fr;gap:14px;align-items:start}
    @media (max-width: 980px){ .twoCol{grid-template-columns:1fr} .statsRow{grid-template-columns:1fr} }

    /* Table responsive: mobile -> horizontal scroll (clean) */
    .tableWrap{
      overflow:auto;
      border:1px solid rgba(255,255,255,.10);
      border-radius:14px;
      -webkit-overflow-scrolling: touch;
    }
    table{width:100%;border-collapse:collapse;min-width:860px}
    th,td{padding:10px;border-bottom:1px solid rgba(255,255,255,.06);text-align:left}
    thead th{border-bottom:1px solid rgba(255,255,255,.10);color: rgba(238,242,255,.80)}

    .dangerBtn{
      border:1px solid rgba(255,79,103,.55)!important;
      background:rgba(255,79,103,.14)!important;
      color: rgba(238,242,255,1)!important;
      padding:10px 12px;border-radius:16px;font-weight:800;
      display:inline-block;
    }
    .ghostBtn{
      border:1px solid rgba(255,255,255,.14);
      background:transparent;
      color: rgba(238,242,255,1);
      padding:10px 12px;border-radius:16px;font-weight:800;
      display:inline-block;
    }
    .primaryBtn{
      border:1px solid rgba(255,255,255,.14);
      background: linear-gradient(135deg, rgba(110,168,255,.35), rgba(139,92,255,.28));
      color: rgba(238,242,255,1);
      padding:12px 14px;border-radius:16px;font-weight:900;
      display:inline-block;
    }
    .mutedText{color: rgba(238,242,255,.65)}
  </style>
</head>
<body>

<header class="topbar">
  <div class="container topbarInner">
    <a class="brand" href="/">
      <img class="brandLogo" src="<?= e($LOGO_PATH) ?>" alt="Logo" onerror="this.style.display='none'">
      <div class="brandName"><?= e($brandText) ?></div>
    </a>

    <div class="menuWrap">
      <button class="hamburger" id="hamburgerBtn" type="button" aria-label="Menu">☰</button>
      <div class="dropdown" id="dropdown">
        <?php
          menu_item("Home", "/");
          menu_item("Privacy Policy", "/?page=privacy");
          menu_item("Terms & Conditions", "/?page=terms");
          menu_item("Disclaimer", "/?page=disclaimer");
          menu_item("Contact", "/?page=contact");
        ?>
        <a href="/admin.php?logout=1">Logout</a>
      </div>
    </div>
  </div>
</header>

<main class="container">
  <section class="hero" style="padding-top:34px">
    <div class="dashGrid">

      <div class="card">
        <div style="display:flex;justify-content:space-between;gap:10px;flex-wrap:wrap;align-items:center">
          <div>
            <h2 class="stepTitle" style="margin:0 0 6px">Admin Dashboard</h2>
            <p class="stepSub mutedText" style="margin:0">Add, edit, delete and search your links.</p>
          </div>
          <a class="primaryBtn" href="/admin.php?logout=1">Logout</a>
        </div>

        <div class="statsRow">
          <div class="statCard">
            <div class="statLbl">Total Links</div>
            <div class="statNum"><?= number_format($totalLinks) ?></div>
          </div>
          <div class="statCard">
            <div class="statLbl">Total Clicks</div>
            <div class="statNum"><?= number_format($totalClicks) ?></div>
          </div>
        </div>

        <?php if ($notice): ?>
          <div class="result ok" style="margin-top:14px"><?= e($notice) ?></div>
        <?php endif; ?>
      </div>

      <div class="twoCol">
        <div class="card">
          <div class="cardTitle"><?= $editRow ? "Edit Link" : "Add Link" ?></div>

          <?php if ($editRow): ?>
            <form class="adminForm" method="post">
              <input type="hidden" name="update_url" value="1">
              <input type="hidden" name="id" value="<?= (int)$editRow['id'] ?>">

              <label>Code</label>
              <input name="code" value="<?= e($editRow['code']) ?>" required>

              <label>Long URL</label>
              <input type="url" name="long_url" value="<?= e($editRow['long_url']) ?>" required>

              <label>Title (optional)</label>
              <input name="title" value="<?= e($editRow['title'] ?? '') ?>">

              <div class="adminBtns">
                <button class="primaryBtn" type="submit">Update</button>
                <a class="ghostBtn" href="/admin.php">Cancel</a>
              </div>
            </form>
          <?php else: ?>
            <form class="adminForm" method="post">
              <input type="hidden" name="add_url" value="1">

              <label>Long URL</label>
              <input type="url" name="long_url" placeholder="https://..." required>

              <label>Custom Code (optional)</label>
              <input name="code" placeholder="e.g. promo01">

              <label>Title (optional)</label>
              <input name="title" placeholder="e.g. My Video">

              <div class="adminBtns">
                <button class="primaryBtn" type="submit">Add Link</button>
              </div>
            </form>
          <?php endif; ?>
        </div>

        <div class="card">
          <div class="cardTitle">Search</div>
          <form class="adminForm" method="get">
            <label>Search by code / title / URL</label>
            <input name="q" value="<?= e($q) ?>" placeholder="Type to search...">
            <div class="adminBtns">
              <button class="ghostBtn" type="submit">Search</button>
              <?php if ($q !== ""): ?>
                <a class="ghostBtn" href="/admin.php">Clear</a>
              <?php endif; ?>
            </div>
          </form>

          <div class="mutedText" style="margin-top:14px">
            Tip: Mobile-এ টেবিল স্ক্রল হবে (ডান দিকে swipe)।
          </div>
        </div>
      </div>

      <div class="card">
        <div class="cardTitle">All Links</div>
        <div class="tableWrap">
          <table>
            <thead>
              <tr>
                <th>ID</th>
                <th>Code</th>
                <th>Short</th>
                <th>Clicks</th>
                <th>Title</th>
                <th>Created</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($rows as $r):
              $shortUrl = base_url() . "/r/" . $r['code'];
            ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <td><b><?= e($r['code']) ?></b></td>
                <td><a href="<?= e($shortUrl) ?>" target="_blank" rel="noopener"><?= e($shortUrl) ?></a></td>
                <td><?= (int)$r['clicks'] ?></td>
                <td><?= e($r['title'] ?? '') ?></td>
                <td><?= e($r['created_at']) ?></td>
                <td>
                  <div class="adminBtns" style="margin-top:0">
                    <a class="ghostBtn" href="/admin.php?edit=<?= (int)$r['id'] ?>">Edit</a>
                    <a class="dangerBtn"
                       href="/admin.php?delete=<?= (int)$r['id'] ?>"
                       onclick="return confirm('Delete this link?')">Delete</a>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>

    </div>
  </section>

  <footer class="footer">
    <div class="footerRow">
      <div>© <?= date('Y') ?> <?= e($SITE_NAME ?: "URL Shortener") ?></div>
      <div class="footerLinks">
        <a href="/?page=privacy">Privacy</a>
        <a href="/?page=terms">Terms</a>
        <a href="/?page=disclaimer">Disclaimer</a>
        <a href="/?page=contact">Contact</a>
      </div>
    </div>
  </footer>
</main>

<script>
(function(){
  const btn = document.getElementById('hamburgerBtn');
  const dd  = document.getElementById('dropdown');
  if(btn && dd){
    btn.addEventListener('click', (e)=>{ e.stopPropagation(); dd.classList.toggle('open'); });
    document.addEventListener('click', ()=> dd.classList.remove('open'));
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') dd.classList.remove('open'); });
  }
})();
</script>

</body>
</html>