<?php
require "config.php";
header("Content-Type: application/json; charset=utf-8");

$action = $_GET['action'] ?? "";

function fail($m,$c=400){ http_response_code($c); echo json_encode(["ok"=>false,"message"=>$m]); exit; }
function ok($a=[]){ echo json_encode(array_merge(["ok"=>true],$a)); exit; }

if($action === "create"){
  $url = trim($_POST['url'] ?? "");
  $title = trim($_POST['title'] ?? "");

  if(!$url) fail("URL দিন");
  if(!is_valid_url($url)) fail("Valid URL দিন (http/https সহ)");

  $pdo = db();
  do{
    $code = make_code(6);
    $st = $pdo->prepare("SELECT id FROM urls WHERE code=? LIMIT 1");
    $st->execute([$code]);
    $exists = $st->fetch();
  } while($exists);

  $st = $pdo->prepare("INSERT INTO urls(code,long_url,title) VALUES(?,?,?)");
  $st->execute([$code, $url, $title ?: null]);

  $short = base_url()."/r/".$code;
  ok(["short"=>$short,"code"=>$code]);
}

fail("Unknown action",404);