(function () {
  // Safety: run after DOM ready even if defer fails
  function ready(fn){
    if(document.readyState !== 'loading') fn();
    else document.addEventListener('DOMContentLoaded', fn);
  }

  ready(function(){
    const btn = document.getElementById('hamburgerBtn');
    const dd  = document.getElementById('dropdown');

    if(!btn || !dd){
      console.log("Menu elements not found. Check IDs: hamburgerBtn, dropdown");
      return;
    }

    function open(){
      dd.classList.add('open');
      btn.setAttribute('aria-expanded','true');
    }
    function close(){
      dd.classList.remove('open');
      btn.setAttribute('aria-expanded','false');
    }
    function toggle(){
      dd.classList.contains('open') ? close() : open();
    }

    btn.addEventListener('click', function(e){
      e.preventDefault();
      e.stopPropagation();
      toggle();
    });

    dd.addEventListener('click', function(e){
      // menu item click should close
      const a = e.target.closest('a');
      if(a) close();
    });

    document.addEventListener('click', function(){
      close();
    });

    document.addEventListener('keydown', function(e){
      if(e.key === 'Escape') close();
    });

    // copy helper
    window.copyText = function(text){
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text)
          .then(()=>alert("Copied!"))
          .catch(()=>prompt("Copy:", text));
      } else {
        prompt("Copy:", text);
      }
    };
  });
})();