<?php
// ===== DB =====
$DB_HOST = "localhost";
$DB_NAME = "mustvuva_urlshort";
$DB_USER = "mustvuva_urlshort";
$DB_PASS = "mustvuva_urlshort";

// ===== Admin =====
$ADMIN_USER = "admin";
$ADMIN_PASS = "123456";

// ===== Site UI =====
$SITE_NAME = "My Shortener";
$SITE_TAGLINE = "Fast 3-step short link system";
$LOGO_PATH = "/images/logo.png";      // আপনার logo
$FAVICON_PATH = "/images/favicon.ico"; // আপনার favicon

function db(): PDO {
  static $pdo = null;
  global $DB_HOST,$DB_NAME,$DB_USER,$DB_PASS;
  if ($pdo) return $pdo;

  $pdo = new PDO("mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4", $DB_USER, $DB_PASS, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false
  ]);
  return $pdo;
}

function base_url(): string {
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https" : "http";
  return $scheme . "://" . $_SERVER['HTTP_HOST'];
}

function e(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function is_valid_url(string $url): bool {
  return preg_match('~^https?://~i', $url) && (bool)filter_var($url, FILTER_VALIDATE_URL);
}

function make_code(int $len=6): string {
  $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
  $out = "";
  for ($i=0;$i<$len;$i++) $out .= $chars[random_int(0, strlen($chars)-1)];
  return $out;
}

function require_admin(): void {
  session_start();
  if (empty($_SESSION['admin'])) {
    header("Location: /admin.php?login=1");
    exit;
  }
}