<?php
require "config.php";
global $SITE_NAME,$LOGO_PATH,$FAVICON_PATH;

$code = preg_replace('/[^A-Za-z0-9]/', '', $_GET['code'] ?? '');
if (!$code) { http_response_code(404); die("Not found"); }

$pdo = db();
$st = $pdo->prepare("SELECT long_url, title FROM urls WHERE code=? LIMIT 1");
$st->execute([$code]);
$row = $st->fetch();
if (!$row) { http_response_code(404); die("Not found"); }

$target = $row['long_url'];
$title  = $row['title'] ?: "Continue";
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($title) ?> - <?= e($SITE_NAME ?: "URL Shortener") ?></title>
  <meta name="robots" content="noindex,follow">
  <link rel="icon" href="<?= e($FAVICON_PATH) ?>">
  <link rel="stylesheet" href="/assets/style.css">
</head>
<body>

<!-- Same style header as your home -->
<header class="topbar">
  <div class="container topbarInner">
    <a class="brand" href="/">
      <img class="brandLogo" src="<?= e($LOGO_PATH) ?>" alt="Logo" onerror="this.style.display='none'">
      <div class="brandName"><?= e(strtoupper($SITE_NAME ?: "SHORTEN WORLD")) ?></div>
    </a>

    <div class="menuWrap">
      <button class="hamburger" id="hamburgerBtn" type="button" aria-label="Menu">☰</button>
      <div class="dropdown" id="dropdown">
        <a href="/">Home</a>
        <a href="/?page=privacy">Privacy Policy</a>
        <a href="/?page=terms">Terms & Conditions</a>
        <a href="/?page=disclaimer">Disclaimer</a>
        <a href="/?page=contact">Contact</a>
        <a href="/admin.php">Admin</a>
      </div>
    </div>
  </div>
</header>

<main class="container">
  <section class="hero" style="padding-top:34px">
    <div class="card" style="max-width:820px">
      <h2 class="stepTitle">Step <span id="stepNo">1</span> / 3</h2>
      <p class="stepSub" id="stepText">Please wait…</p>

      <!-- TOP AD -->
      <div class="adBox" style="margin-top:14px" id="adTop">
        <!-- এখানে আপনার AdSense/Ad code বসাবেন -->
        AD BOX (TOP)
      </div>

      <div class="timerRow">
        <div class="timerPill">
          Time left: <span id="timeLeft">5</span>s
        </div>
      </div>

      <!-- BOTTOM AD -->
      <div class="adBox" style="margin-top:14px" id="adBottom">
        <!-- এখানে আপনার AdSense/Ad code বসাবেন -->
        AD BOX (BOTTOM)
      </div>

      <div style="margin-top:14px; display:flex; gap:10px; flex-wrap:wrap">
        <button class="btn primary" id="nextBtn" type="button" disabled style="opacity:.6">
          Next
        </button>

        <a class="btn primary" id="finalBtn" href="<?= e($target) ?>" rel="nofollow noopener" style="display:none">
          Open Destination
        </a>
      </div>

      <input type="hidden" id="targetUrl" value="<?= e($target) ?>">
    </div>
  </section>

  <footer class="footer">
    <div class="footerRow">
      <div>© <?= date('Y') ?> <?= e($SITE_NAME ?: "URL Shortener") ?></div>
      <div class="footerLinks">
        <a href="/?page=privacy">Privacy</a>
        <a href="/?page=terms">Terms</a>
        <a href="/?page=disclaimer">Disclaimer</a>
        <a href="/?page=contact">Contact</a>
      </div>
    </div>
  </footer>
</main>

<script>
/* Dropdown menu (same behavior everywhere) */
(function(){
  const btn = document.getElementById('hamburgerBtn');
  const dd  = document.getElementById('dropdown');
  if(btn && dd){
    btn.addEventListener('click', (e)=>{ e.stopPropagation(); dd.classList.toggle('open'); });
    document.addEventListener('click', ()=> dd.classList.remove('open'));
    document.addEventListener('keydown', (e)=>{ if(e.key==='Escape') dd.classList.remove('open'); });
  }
})();

/* Step system: Step1 timer -> Next -> Step2 timer -> Next -> Final */
const stepNo   = document.getElementById('stepNo');
const stepText = document.getElementById('stepText');
const timeLeft = document.getElementById('timeLeft');
const nextBtn  = document.getElementById('nextBtn');
const finalBtn = document.getElementById('finalBtn');
const target   = document.getElementById('targetUrl').value;

let step = 1;

function setNextEnabled(enabled){
  nextBtn.disabled = !enabled;
  nextBtn.style.opacity = enabled ? "1" : ".6";
}

function startCountdown(seconds){
  return new Promise(resolve=>{
    let left = seconds;
    timeLeft.textContent = String(left);
    setNextEnabled(false);

    const t = setInterval(()=>{
      left--;
      if(left <= 0){
        clearInterval(t);
        timeLeft.textContent = "0";
        setNextEnabled(true);
        resolve();
      } else {
        timeLeft.textContent = String(left);
      }
    }, 1000);
  });
}

function renderStep(){
  stepNo.textContent = String(step);

  if(step === 1){
    stepText.textContent = "Watch the ads and wait for the timer. Then tap Next.";
    nextBtn.textContent = "Next (Step 2)";
    nextBtn.style.display = "inline-block";
    finalBtn.style.display = "none";
  }
  if(step === 2){
    stepText.textContent = "Second step: wait again. Then tap Next.";
    nextBtn.textContent = "Next (Final)";
    nextBtn.style.display = "inline-block";
    finalBtn.style.display = "none";
  }
  if(step === 3){
    stepText.textContent = "Done! Tap the button to open destination.";
    nextBtn.style.display = "none";
    finalBtn.style.display = "inline-block";
    finalBtn.href = target;
    setNextEnabled(false);
    timeLeft.textContent = "0";
  }
}

async function runStep(){
  renderStep();
  if(step === 1 || step === 2){
    await startCountdown(5);
  }
}

nextBtn.addEventListener('click', ()=>{
  if(nextBtn.disabled) return;
  step++;
  if(step > 3) step = 3;
  runStep();
});

runStep();
</script>

</body>
</html>