<?php
require "config.php";
global $SITE_NAME,$LOGO_PATH,$FAVICON_PATH;

$page = $_GET['page'] ?? 'home';

$msg = "";
$short = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['do_generate'])) {
  $url = trim($_POST['url'] ?? "");

  if (!$url) $msg = "URL দিন";
  else if (!is_valid_url($url)) $msg = "Valid URL দিন (http/https সহ)";
  else {
    $pdo = db();
    do {
      $code = make_code(6);
      $st = $pdo->prepare("SELECT id FROM urls WHERE code=? LIMIT 1");
      $st->execute([$code]);
      $exists = $st->fetch();
    } while($exists);

    $st = $pdo->prepare("INSERT INTO urls(code,long_url,title) VALUES(?,?,NULL)");
    $st->execute([$code, $url]);

    $short = base_url() . "/r/" . $code;
  }
  $page = 'home';
}

function menu_item($label, $href){
  echo '<a href="'.$href.'">'.e($label).'</a>';
}

// Header brand text (যেমন SHORTEN WORLD টাইপ)
$brandText = strtoupper($SITE_NAME ?: "SHORTEN WORLD");
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($SITE_NAME ?: "URL Shortener") ?></title>
  <meta name="description" content="URL shortener with 3-step redirect flow.">
  <link rel="icon" href="<?= e($FAVICON_PATH) ?>">
  <link rel="stylesheet" href="/assets/style.css">
  <script defer src="/assets/app.js"></script>
</head>
<body>

<header class="topbar">
  <div class="container topbarInner">
    <a class="brand" href="/">
      <img class="brandLogo" src="<?= e($LOGO_PATH) ?>" alt="Logo" onerror="this.style.display='none'">
      <div class="brandName"><?= e($brandText) ?></div>
    </a>

    <div class="menuWrap">
      <button class="hamburger" id="hamburgerBtn" type="button" aria-label="Menu">
        ☰
      </button>
      <div class="dropdown" id="dropdown">
        <?php
          menu_item("Home", "/");
          menu_item("Privacy Policy", "/?page=privacy");
          menu_item("Terms & Conditions", "/?page=terms");
          menu_item("Disclaimer", "/?page=disclaimer");
          menu_item("Contact", "/?page=contact");
          menu_item("Admin", "/admin.php");
        ?>
      </div>
    </div>
  </div>
</header>

<main class="container">

<?php if ($page === 'home'): ?>
  <section class="hero">
    <h1 class="hTitle">URL Shortener</h1>

    <p class="hText">
      World's leading URL shortener. Shorten, edit and delete links. Generate links with tracking analytics.
      Boost your brand with your branded domain name and more.
    </p>

    <form method="post" class="linkBar">
      <input type="hidden" name="do_generate" value="1">
      <input name="url" type="url" placeholder="Your long link" required>
      <button type="submit">Shorten link</button>
    </form>

    <?php if ($msg): ?>
      <div class="result bad"><?= e($msg) ?></div>
    <?php endif; ?>

    <?php if ($short): ?>
      <div class="result">
        <b>Short URL:</b>
        <a href="<?= e($short) ?>" target="_blank" rel="noopener"><?= e($short) ?></a>
        <div style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap">
          <button type="button" class="hamburger" style="width:auto;height:auto;padding:10px 12px" onclick="copyText('<?= e($short) ?>')">Copy</button>
          <a class="hamburger" style="width:auto;height:auto;padding:10px 12px;display:inline-flex;align-items:center;justify-content:center" href="<?= e($short) ?>" target="_blank" rel="noopener">Open</a>
        </div>
      </div>
    <?php endif; ?>
  </section>

<?php elseif ($page === 'privacy'): ?>
  <section class="hero">
    <h1 class="hTitle">Privacy Policy</h1>
    <p class="hText">এখানে আপনার Privacy Policy লিখবেন।</p>
  </section>

<?php elseif ($page === 'terms'): ?>
  <section class="hero">
    <h1 class="hTitle">Terms & Conditions</h1>
    <p class="hText">এখানে Terms & Conditions লিখবেন।</p>
  </section>

<?php elseif ($page === 'disclaimer'): ?>
  <section class="hero">
    <h1 class="hTitle">Disclaimer</h1>
    <p class="hText">এখানে Disclaimer লিখবেন।</p>
  </section>

<?php elseif ($page === 'contact'): ?>
  <section class="hero">
    <h1 class="hTitle">Contact</h1>
    <p class="hText">
      Email: you@example.com <br>
      WhatsApp: +8801XXXXXXXXX
    </p>
  </section>

<?php else: ?>
  <section class="hero">
    <h1 class="hTitle">Page not found</h1>
    <p class="hText">এই পেজটি নেই।</p>
  </section>
<?php endif; ?>

  <footer class="footer">
    <div class="footerRow">
      <div>© <?= date('Y') ?> <?= e($SITE_NAME ?: "URL Shortener") ?></div>
      <div class="footerLinks">
        <a href="/?page=privacy">Privacy</a>
        <a href="/?page=terms">Terms</a>
        <a href="/?page=disclaimer">Disclaimer</a>
        <a href="/?page=contact">Contact</a>
      </div>
    </div>
  </footer>

</main>
</body>
</html>